// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.HybridNetwork
{
    /// <summary>
    /// A class representing a collection of <see cref="ArtifactStoreResource"/> and their operations.
    /// Each <see cref="ArtifactStoreResource"/> in the collection will belong to the same instance of <see cref="PublisherResource"/>.
    /// To get an <see cref="ArtifactStoreCollection"/> instance call the GetArtifactStores method from an instance of <see cref="PublisherResource"/>.
    /// </summary>
    public partial class ArtifactStoreCollection : ArmCollection, IEnumerable<ArtifactStoreResource>, IAsyncEnumerable<ArtifactStoreResource>
    {
        private readonly ClientDiagnostics _artifactStoreClientDiagnostics;
        private readonly ArtifactStoresRestOperations _artifactStoreRestClient;

        /// <summary> Initializes a new instance of the <see cref="ArtifactStoreCollection"/> class for mocking. </summary>
        protected ArtifactStoreCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ArtifactStoreCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ArtifactStoreCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _artifactStoreClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.HybridNetwork", ArtifactStoreResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ArtifactStoreResource.ResourceType, out string artifactStoreApiVersion);
            _artifactStoreRestClient = new ArtifactStoresRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, artifactStoreApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != PublisherResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, PublisherResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a artifact store.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ArtifactStores_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ArtifactStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="artifactStoreName"> The name of the artifact store. </param>
        /// <param name="data"> Parameters supplied to the create or update application group operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="artifactStoreName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactStoreName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ArtifactStoreResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string artifactStoreName, ArtifactStoreData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(artifactStoreName, nameof(artifactStoreName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _artifactStoreClientDiagnostics.CreateScope("ArtifactStoreCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _artifactStoreRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, artifactStoreName, data, cancellationToken).ConfigureAwait(false);
                var operation = new HybridNetworkArmOperation<ArtifactStoreResource>(new ArtifactStoreOperationSource(Client), _artifactStoreClientDiagnostics, Pipeline, _artifactStoreRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, artifactStoreName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a artifact store.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ArtifactStores_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ArtifactStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="artifactStoreName"> The name of the artifact store. </param>
        /// <param name="data"> Parameters supplied to the create or update application group operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="artifactStoreName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactStoreName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ArtifactStoreResource> CreateOrUpdate(WaitUntil waitUntil, string artifactStoreName, ArtifactStoreData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(artifactStoreName, nameof(artifactStoreName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _artifactStoreClientDiagnostics.CreateScope("ArtifactStoreCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _artifactStoreRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, artifactStoreName, data, cancellationToken);
                var operation = new HybridNetworkArmOperation<ArtifactStoreResource>(new ArtifactStoreOperationSource(Client), _artifactStoreClientDiagnostics, Pipeline, _artifactStoreRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, artifactStoreName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified artifact store.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ArtifactStores_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ArtifactStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="artifactStoreName"> The name of the artifact store. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="artifactStoreName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactStoreName"/> is null. </exception>
        public virtual async Task<Response<ArtifactStoreResource>> GetAsync(string artifactStoreName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(artifactStoreName, nameof(artifactStoreName));

            using var scope = _artifactStoreClientDiagnostics.CreateScope("ArtifactStoreCollection.Get");
            scope.Start();
            try
            {
                var response = await _artifactStoreRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, artifactStoreName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ArtifactStoreResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified artifact store.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ArtifactStores_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ArtifactStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="artifactStoreName"> The name of the artifact store. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="artifactStoreName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactStoreName"/> is null. </exception>
        public virtual Response<ArtifactStoreResource> Get(string artifactStoreName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(artifactStoreName, nameof(artifactStoreName));

            using var scope = _artifactStoreClientDiagnostics.CreateScope("ArtifactStoreCollection.Get");
            scope.Start();
            try
            {
                var response = _artifactStoreRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, artifactStoreName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ArtifactStoreResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information of the ArtifactStores under publisher.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ArtifactStores_ListByPublisher</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ArtifactStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ArtifactStoreResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ArtifactStoreResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _artifactStoreRestClient.CreateListByPublisherRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _artifactStoreRestClient.CreateListByPublisherNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ArtifactStoreResource(Client, ArtifactStoreData.DeserializeArtifactStoreData(e)), _artifactStoreClientDiagnostics, Pipeline, "ArtifactStoreCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets information of the ArtifactStores under publisher.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ArtifactStores_ListByPublisher</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ArtifactStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ArtifactStoreResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ArtifactStoreResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _artifactStoreRestClient.CreateListByPublisherRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _artifactStoreRestClient.CreateListByPublisherNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ArtifactStoreResource(Client, ArtifactStoreData.DeserializeArtifactStoreData(e)), _artifactStoreClientDiagnostics, Pipeline, "ArtifactStoreCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ArtifactStores_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ArtifactStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="artifactStoreName"> The name of the artifact store. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="artifactStoreName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactStoreName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string artifactStoreName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(artifactStoreName, nameof(artifactStoreName));

            using var scope = _artifactStoreClientDiagnostics.CreateScope("ArtifactStoreCollection.Exists");
            scope.Start();
            try
            {
                var response = await _artifactStoreRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, artifactStoreName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ArtifactStores_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ArtifactStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="artifactStoreName"> The name of the artifact store. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="artifactStoreName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactStoreName"/> is null. </exception>
        public virtual Response<bool> Exists(string artifactStoreName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(artifactStoreName, nameof(artifactStoreName));

            using var scope = _artifactStoreClientDiagnostics.CreateScope("ArtifactStoreCollection.Exists");
            scope.Start();
            try
            {
                var response = _artifactStoreRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, artifactStoreName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ArtifactStores_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ArtifactStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="artifactStoreName"> The name of the artifact store. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="artifactStoreName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactStoreName"/> is null. </exception>
        public virtual async Task<NullableResponse<ArtifactStoreResource>> GetIfExistsAsync(string artifactStoreName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(artifactStoreName, nameof(artifactStoreName));

            using var scope = _artifactStoreClientDiagnostics.CreateScope("ArtifactStoreCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _artifactStoreRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, artifactStoreName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ArtifactStoreResource>(response.GetRawResponse());
                return Response.FromValue(new ArtifactStoreResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ArtifactStores_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ArtifactStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="artifactStoreName"> The name of the artifact store. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="artifactStoreName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactStoreName"/> is null. </exception>
        public virtual NullableResponse<ArtifactStoreResource> GetIfExists(string artifactStoreName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(artifactStoreName, nameof(artifactStoreName));

            using var scope = _artifactStoreClientDiagnostics.CreateScope("ArtifactStoreCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _artifactStoreRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, artifactStoreName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ArtifactStoreResource>(response.GetRawResponse());
                return Response.FromValue(new ArtifactStoreResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ArtifactStoreResource> IEnumerable<ArtifactStoreResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ArtifactStoreResource> IAsyncEnumerable<ArtifactStoreResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
