// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.HybridNetwork.Samples
{
    public partial class Sample_NetworkServiceDesignGroupCollection
    {
        // Get networkServiceDesign groups under publisher resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetNetworkServiceDesignGroupsUnderPublisherResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkServiceDesignGroupsListByPublisherName.json
            // this example is just showing the usage of "NetworkServiceDesignGroups_ListByPublisher" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PublisherResource created on azure
            // for more information of creating PublisherResource, please refer to the document of PublisherResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            ResourceIdentifier publisherResourceId = PublisherResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName);
            PublisherResource publisher = client.GetPublisherResource(publisherResourceId);

            // get the collection of this NetworkServiceDesignGroupResource
            NetworkServiceDesignGroupCollection collection = publisher.GetNetworkServiceDesignGroups();

            // invoke the operation and iterate over the result
            await foreach (NetworkServiceDesignGroupResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                NetworkServiceDesignGroupData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Create or update the network service design group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateTheNetworkServiceDesignGroup()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkServiceDesignGroupCreate.json
            // this example is just showing the usage of "NetworkServiceDesignGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PublisherResource created on azure
            // for more information of creating PublisherResource, please refer to the document of PublisherResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            ResourceIdentifier publisherResourceId = PublisherResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName);
            PublisherResource publisher = client.GetPublisherResource(publisherResourceId);

            // get the collection of this NetworkServiceDesignGroupResource
            NetworkServiceDesignGroupCollection collection = publisher.GetNetworkServiceDesignGroups();

            // invoke the operation
            string networkServiceDesignGroupName = "TestNetworkServiceDesignGroupName";
            NetworkServiceDesignGroupData data = new NetworkServiceDesignGroupData(new AzureLocation("eastus"));
            ArmOperation<NetworkServiceDesignGroupResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, networkServiceDesignGroupName, data);
            NetworkServiceDesignGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkServiceDesignGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a networkServiceDesign group resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetANetworkServiceDesignGroupResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkServiceDesignGroupGet.json
            // this example is just showing the usage of "NetworkServiceDesignGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PublisherResource created on azure
            // for more information of creating PublisherResource, please refer to the document of PublisherResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            ResourceIdentifier publisherResourceId = PublisherResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName);
            PublisherResource publisher = client.GetPublisherResource(publisherResourceId);

            // get the collection of this NetworkServiceDesignGroupResource
            NetworkServiceDesignGroupCollection collection = publisher.GetNetworkServiceDesignGroups();

            // invoke the operation
            string networkServiceDesignGroupName = "TestNetworkServiceDesignGroupName";
            NetworkServiceDesignGroupResource result = await collection.GetAsync(networkServiceDesignGroupName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkServiceDesignGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a networkServiceDesign group resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetANetworkServiceDesignGroupResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkServiceDesignGroupGet.json
            // this example is just showing the usage of "NetworkServiceDesignGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PublisherResource created on azure
            // for more information of creating PublisherResource, please refer to the document of PublisherResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            ResourceIdentifier publisherResourceId = PublisherResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName);
            PublisherResource publisher = client.GetPublisherResource(publisherResourceId);

            // get the collection of this NetworkServiceDesignGroupResource
            NetworkServiceDesignGroupCollection collection = publisher.GetNetworkServiceDesignGroups();

            // invoke the operation
            string networkServiceDesignGroupName = "TestNetworkServiceDesignGroupName";
            bool result = await collection.ExistsAsync(networkServiceDesignGroupName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a networkServiceDesign group resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetANetworkServiceDesignGroupResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkServiceDesignGroupGet.json
            // this example is just showing the usage of "NetworkServiceDesignGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PublisherResource created on azure
            // for more information of creating PublisherResource, please refer to the document of PublisherResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            ResourceIdentifier publisherResourceId = PublisherResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName);
            PublisherResource publisher = client.GetPublisherResource(publisherResourceId);

            // get the collection of this NetworkServiceDesignGroupResource
            NetworkServiceDesignGroupCollection collection = publisher.GetNetworkServiceDesignGroups();

            // invoke the operation
            string networkServiceDesignGroupName = "TestNetworkServiceDesignGroupName";
            NullableResponse<NetworkServiceDesignGroupResource> response = await collection.GetIfExistsAsync(networkServiceDesignGroupName);
            NetworkServiceDesignGroupResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                NetworkServiceDesignGroupData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
