// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.HybridNetwork.Samples
{
    public partial class Sample_ComponentResource
    {
        // Get component resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetComponentResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ComponentGet.json
            // this example is just showing the usage of "Components_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ComponentResource created on azure
            // for more information of creating ComponentResource, please refer to the document of ComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string networkFunctionName = "testNf";
            string componentName = "testComponent";
            ResourceIdentifier componentResourceId = ComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkFunctionName, componentName);
            ComponentResource component = client.GetComponentResource(componentResourceId);

            // invoke the operation
            ComponentResource result = await component.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ComponentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
