// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.HybridNetwork.Models;

namespace Azure.ResourceManager.HybridNetwork.Samples
{
    public partial class Sample_ArtifactStoreResource
    {
        // Delete a artifact store of publisher resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAArtifactStoreOfPublisherResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactStoreDelete.json
            // this example is just showing the usage of "ArtifactStores_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStore";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // invoke the operation
            await artifactStore.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get a artifact store resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAArtifactStoreResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactStoreGet.json
            // this example is just showing the usage of "ArtifactStores_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStoreName";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // invoke the operation
            ArtifactStoreResource result = await artifactStore.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactStoreData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update artifact store resource tags
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateArtifactStoreResourceTags()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactStoreUpdateTags.json
            // this example is just showing the usage of "ArtifactStores_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStore";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // invoke the operation
            TagsObject tagsObject = new TagsObject()
            {
                Tags =
{
["tag1"] = "value1",
["tag2"] = "value2",
},
            };
            ArtifactStoreResource result = await artifactStore.UpdateAsync(tagsObject);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactStoreData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List artifacts under an artifact store
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetProxyArtifacts_ListArtifactsUnderAnArtifactStore()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/PureProxyArtifact/ArtifactList.json
            // this example is just showing the usage of "ProxyArtifact_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestResourceGroup";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStoreName";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // invoke the operation and iterate over the result
            await foreach (ProxyArtifactListOverview item in artifactStore.GetProxyArtifactsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get an artifact overview
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetProxyArtifacts_GetAnArtifactOverview()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/PureProxyArtifact/ArtifactGet.json
            // this example is just showing the usage of "ProxyArtifact_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestResourceGroup";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStoreName";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // invoke the operation and iterate over the result
            string artifactName = "fedrbac";
            await foreach (ProxyArtifactVersionsListOverview item in artifactStore.GetProxyArtifactsAsync(artifactName))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Update an artifact state
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateStateProxyArtifact_UpdateAnArtifactState()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/PureProxyArtifact/ArtifactChangeState.json
            // this example is just showing the usage of "ProxyArtifact_UpdateState" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestResourceGroup";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStoreName";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // invoke the operation
            string artifactVersionName = "1.0.0";
            string artifactName = "fedrbac";
            ArtifactChangeState artifactChangeState = new ArtifactChangeState()
            {
                ArtifactState = ArtifactState.Deprecated,
            };
            ArmOperation<ProxyArtifactVersionsListOverview> lro = await artifactStore.UpdateStateProxyArtifactAsync(WaitUntil.Completed, artifactVersionName, artifactName, artifactChangeState);
            ProxyArtifactVersionsListOverview result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
