// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.HybridNetwork.Models;

namespace Azure.ResourceManager.HybridNetwork.Samples
{
    public partial class Sample_ArtifactManifestCollection
    {
        // Get artifact manifest list resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetArtifactManifestListResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestListByArtifactStore.json
            // this example is just showing the usage of "ArtifactManifests_ListByArtifactStore" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStore";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // get the collection of this ArtifactManifestResource
            ArtifactManifestCollection collection = artifactStore.GetArtifactManifests();

            // invoke the operation and iterate over the result
            await foreach (ArtifactManifestResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArtifactManifestData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Create or update the artifact manifest resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateTheArtifactManifestResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestCreate.json
            // this example is just showing the usage of "ArtifactManifests_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStore";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // get the collection of this ArtifactManifestResource
            ArtifactManifestCollection collection = artifactStore.GetArtifactManifests();

            // invoke the operation
            string artifactManifestName = "TestManifest";
            ArtifactManifestData data = new ArtifactManifestData(new AzureLocation("eastus"))
            {
                Properties = new ArtifactManifestPropertiesFormat()
                {
                    Artifacts =
{
new ManifestArtifactFormat()
{
ArtifactName = "fed-rbac",
ArtifactType = ArtifactType.OCIArtifact,
ArtifactVersion = "1.0.0",
},new ManifestArtifactFormat()
{
ArtifactName = "nginx",
ArtifactType = ArtifactType.OCIArtifact,
ArtifactVersion = "v1",
}
},
                },
            };
            ArmOperation<ArtifactManifestResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, artifactManifestName, data);
            ArtifactManifestResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactManifestData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a artifact manifest resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAArtifactManifestResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestGet.json
            // this example is just showing the usage of "ArtifactManifests_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStore";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // get the collection of this ArtifactManifestResource
            ArtifactManifestCollection collection = artifactStore.GetArtifactManifests();

            // invoke the operation
            string artifactManifestName = "TestManifest";
            ArtifactManifestResource result = await collection.GetAsync(artifactManifestName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactManifestData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a artifact manifest resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAArtifactManifestResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestGet.json
            // this example is just showing the usage of "ArtifactManifests_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStore";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // get the collection of this ArtifactManifestResource
            ArtifactManifestCollection collection = artifactStore.GetArtifactManifests();

            // invoke the operation
            string artifactManifestName = "TestManifest";
            bool result = await collection.ExistsAsync(artifactManifestName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a artifact manifest resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAArtifactManifestResource()
        {
            // Generated from example definition: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestGet.json
            // this example is just showing the usage of "ArtifactManifests_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArtifactStoreResource created on azure
            // for more information of creating ArtifactStoreResource, please refer to the document of ArtifactStoreResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string publisherName = "TestPublisher";
            string artifactStoreName = "TestArtifactStore";
            ResourceIdentifier artifactStoreResourceId = ArtifactStoreResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, publisherName, artifactStoreName);
            ArtifactStoreResource artifactStore = client.GetArtifactStoreResource(artifactStoreResourceId);

            // get the collection of this ArtifactManifestResource
            ArtifactManifestCollection collection = artifactStore.GetArtifactManifests();

            // invoke the operation
            string artifactManifestName = "TestManifest";
            NullableResponse<ArtifactManifestResource> response = await collection.GetIfExistsAsync(artifactManifestName);
            ArtifactManifestResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArtifactManifestData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
