// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Kubernetes.Models
{
    /// <summary> The ListClusterUserCredentialProperties. </summary>
    public partial class ListClusterUserCredentialProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ListClusterUserCredentialProperties"/>. </summary>
        /// <param name="authenticationMethod"> The mode of client authentication. </param>
        /// <param name="clientProxy"> Boolean value to indicate whether the request is for client side proxy or not. </param>
        public ListClusterUserCredentialProperties(AuthenticationMethod authenticationMethod, bool clientProxy)
        {
            AuthenticationMethod = authenticationMethod;
            ClientProxy = clientProxy;
        }

        /// <summary> Initializes a new instance of <see cref="ListClusterUserCredentialProperties"/>. </summary>
        /// <param name="authenticationMethod"> The mode of client authentication. </param>
        /// <param name="clientProxy"> Boolean value to indicate whether the request is for client side proxy or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ListClusterUserCredentialProperties(AuthenticationMethod authenticationMethod, bool clientProxy, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AuthenticationMethod = authenticationMethod;
            ClientProxy = clientProxy;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ListClusterUserCredentialProperties"/> for deserialization. </summary>
        internal ListClusterUserCredentialProperties()
        {
        }

        /// <summary> The mode of client authentication. </summary>
        [WirePath("authenticationMethod")]
        public AuthenticationMethod AuthenticationMethod { get; }
        /// <summary> Boolean value to indicate whether the request is for client side proxy or not. </summary>
        [WirePath("clientProxy")]
        public bool ClientProxy { get; }
    }
}
