// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kubernetes.Models
{
    /// <summary> Represents the connectivity status of the connected cluster. </summary>
    public readonly partial struct ConnectivityStatus : IEquatable<ConnectivityStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectivityStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectivityStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConnectingValue = "Connecting";
        private const string ConnectedValue = "Connected";
        private const string OfflineValue = "Offline";
        private const string ExpiredValue = "Expired";

        /// <summary> Connecting. </summary>
        public static ConnectivityStatus Connecting { get; } = new ConnectivityStatus(ConnectingValue);
        /// <summary> Connected. </summary>
        public static ConnectivityStatus Connected { get; } = new ConnectivityStatus(ConnectedValue);
        /// <summary> Offline. </summary>
        public static ConnectivityStatus Offline { get; } = new ConnectivityStatus(OfflineValue);
        /// <summary> Expired. </summary>
        public static ConnectivityStatus Expired { get; } = new ConnectivityStatus(ExpiredValue);
        /// <summary> Determines if two <see cref="ConnectivityStatus"/> values are the same. </summary>
        public static bool operator ==(ConnectivityStatus left, ConnectivityStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectivityStatus"/> values are not the same. </summary>
        public static bool operator !=(ConnectivityStatus left, ConnectivityStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectivityStatus"/>. </summary>
        public static implicit operator ConnectivityStatus(string value) => new ConnectivityStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectivityStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectivityStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
