// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Kubernetes.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmKubernetesModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Kubernetes.ConnectedClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The identity of the connected cluster. Current supported identity types: None, SystemAssigned. </param>
        /// <param name="agentPublicKeyCertificate"> Base64 encoded public certificate used by the agent to do the initial handshake to the backend services in Azure. </param>
        /// <param name="kubernetesVersion"> The Kubernetes version of the connected cluster resource. </param>
        /// <param name="totalNodeCount"> Number of nodes present in the connected cluster resource. </param>
        /// <param name="totalCoreCount"> Number of CPU cores present in the connected cluster resource. </param>
        /// <param name="agentVersion"> Version of the agent running on the connected cluster resource. </param>
        /// <param name="provisioningState"> Provisioning state of the connected cluster resource. </param>
        /// <param name="distribution"> The Kubernetes distribution running on this connected cluster. </param>
        /// <param name="infrastructure"> The infrastructure on which the Kubernetes cluster represented by this connected cluster is running on. </param>
        /// <param name="offering"> Connected cluster offering. </param>
        /// <param name="managedIdentityCertificateExpirationOn"> Expiration time of the managed identity certificate. </param>
        /// <param name="lastConnectivityOn"> Time representing the last instance when heart beat was received from the cluster. </param>
        /// <param name="connectivityStatus"> Represents the connectivity status of the connected cluster. </param>
        /// <param name="privateLinkState"> Property which describes the state of private link on a connected cluster resource. </param>
        /// <param name="privateLinkScopeResourceId"> The resource id of the private link scope this connected cluster is assigned to, if any. </param>
        /// <returns> A new <see cref="Kubernetes.ConnectedClusterData"/> instance for mocking. </returns>
        public static ConnectedClusterData ConnectedClusterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, string agentPublicKeyCertificate = null, string kubernetesVersion = null, int? totalNodeCount = null, int? totalCoreCount = null, string agentVersion = null, ProvisioningState? provisioningState = null, string distribution = null, string infrastructure = null, string offering = null, DateTimeOffset? managedIdentityCertificateExpirationOn = null, DateTimeOffset? lastConnectivityOn = null, ConnectivityStatus? connectivityStatus = null, PrivateLinkState? privateLinkState = null, string privateLinkScopeResourceId = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ConnectedClusterData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                agentPublicKeyCertificate,
                kubernetesVersion,
                totalNodeCount,
                totalCoreCount,
                agentVersion,
                provisioningState,
                distribution,
                infrastructure,
                offering,
                managedIdentityCertificateExpirationOn,
                lastConnectivityOn,
                connectivityStatus,
                privateLinkState,
                privateLinkScopeResourceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CredentialResults"/>. </summary>
        /// <param name="hybridConnectionConfig"> Contains the REP (rendezvous endpoint) and “Sender” access token. </param>
        /// <param name="kubeconfigs"> Base64-encoded Kubernetes configuration file. </param>
        /// <returns> A new <see cref="Models.CredentialResults"/> instance for mocking. </returns>
        public static CredentialResults CredentialResults(HybridConnectionConfig hybridConnectionConfig = null, IEnumerable<CredentialResult> kubeconfigs = null)
        {
            kubeconfigs ??= new List<CredentialResult>();

            return new CredentialResults(hybridConnectionConfig, kubeconfigs?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridConnectionConfig"/>. </summary>
        /// <param name="expirationTime"> Timestamp when this token will be expired. </param>
        /// <param name="hybridConnectionName"> Name of the connection. </param>
        /// <param name="relay"> Name of the relay. </param>
        /// <param name="token"> Sender access token. </param>
        /// <returns> A new <see cref="Models.HybridConnectionConfig"/> instance for mocking. </returns>
        public static HybridConnectionConfig HybridConnectionConfig(long? expirationTime = null, string hybridConnectionName = null, string relay = null, string token = null)
        {
            return new HybridConnectionConfig(expirationTime, hybridConnectionName, relay, token, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CredentialResult"/>. </summary>
        /// <param name="name"> The name of the credential. </param>
        /// <param name="value"> Base64-encoded Kubernetes configuration file. </param>
        /// <returns> A new <see cref="Models.CredentialResult"/> instance for mocking. </returns>
        public static CredentialResult CredentialResult(string name = null, byte[] value = null)
        {
            return new CredentialResult(name, value, serializedAdditionalRawData: null);
        }
    }
}
