// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.HybridConnectivity.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmHybridConnectivityModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="HybridConnectivity.EndpointResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="endpointType"> The type of endpoint. </param>
        /// <param name="resourceId"> The resource Id of the connectivity endpoint (optional). </param>
        /// <param name="provisioningState"></param>
        /// <param name="createdBy"> The identity that created the resource. </param>
        /// <param name="createdByType"> The type of identity that created the resource. </param>
        /// <param name="createdOn"> The timestamp of resource creation (UTC). </param>
        /// <param name="lastModifiedBy"> The identity that last modified the resource. </param>
        /// <param name="lastModifiedByType"> The type of identity that last modified the resource. </param>
        /// <param name="lastModifiedOn"> The timestamp of resource last modification (UTC). </param>
        /// <returns> A new <see cref="HybridConnectivity.EndpointResourceData"/> instance for mocking. </returns>
        public static EndpointResourceData EndpointResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, EndpointType? endpointType = null, string resourceId = null, string provisioningState = null, string createdBy = null, CreatedByType? createdByType = null, DateTimeOffset? createdOn = null, string lastModifiedBy = null, CreatedByType? lastModifiedByType = null, DateTimeOffset? lastModifiedOn = null)
        {
            return new EndpointResourceData(
                id,
                name,
                resourceType,
                systemData,
                endpointType,
                resourceId,
                provisioningState,
                createdBy,
                createdByType,
                createdOn,
                lastModifiedBy,
                lastModifiedByType,
                lastModifiedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TargetResourceEndpointAccess"/>. </summary>
        /// <param name="namespaceName"> The namespace name. </param>
        /// <param name="namespaceNameSuffix"> The suffix domain name of relay namespace. </param>
        /// <param name="hybridConnectionName"> Azure Relay hybrid connection name for the resource. </param>
        /// <param name="accessKey"> Access key for hybrid connection. </param>
        /// <param name="expiresOn"> The expiration of access key in unix time. </param>
        /// <returns> A new <see cref="Models.TargetResourceEndpointAccess"/> instance for mocking. </returns>
        public static TargetResourceEndpointAccess TargetResourceEndpointAccess(string namespaceName = null, string namespaceNameSuffix = null, string hybridConnectionName = null, string accessKey = null, long? expiresOn = null)
        {
            return new TargetResourceEndpointAccess(
                namespaceName,
                namespaceNameSuffix,
                hybridConnectionName,
                accessKey,
                expiresOn,
                serializedAdditionalRawData: null);
        }
    }
}
