// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.HybridConnectivity.Models;

namespace Azure.ResourceManager.HybridConnectivity.Samples
{
    public partial class Sample_EndpointResource
    {
        // HybridConnectivityEndpointsGetCustom
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_HybridConnectivityEndpointsGetCustom()
        {
            // Generated from example definition: specification/hybridconnectivity/resource-manager/Microsoft.HybridConnectivity/preview/2021-10-06-preview/examples/EndpointsGetCustom.json
            // this example is just showing the usage of "Endpoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EndpointResource created on azure
            // for more information of creating EndpointResource, please refer to the document of EndpointResource
            string scope = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine";
            string endpointName = "custom";
            ResourceIdentifier endpointResourceId = EndpointResource.CreateResourceIdentifier(scope, endpointName);
            EndpointResource endpointResource = client.GetEndpointResource(endpointResourceId);

            // invoke the operation
            EndpointResource result = await endpointResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EndpointResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // HybridConnectivityEndpointsGetDefault
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_HybridConnectivityEndpointsGetDefault()
        {
            // Generated from example definition: specification/hybridconnectivity/resource-manager/Microsoft.HybridConnectivity/preview/2021-10-06-preview/examples/EndpointsGetDefault.json
            // this example is just showing the usage of "Endpoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EndpointResource created on azure
            // for more information of creating EndpointResource, please refer to the document of EndpointResource
            string scope = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine";
            string endpointName = "default";
            ResourceIdentifier endpointResourceId = EndpointResource.CreateResourceIdentifier(scope, endpointName);
            EndpointResource endpointResource = client.GetEndpointResource(endpointResourceId);

            // invoke the operation
            EndpointResource result = await endpointResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EndpointResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // HybridConnectivityEndpointsPatchDefault
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_HybridConnectivityEndpointsPatchDefault()
        {
            // Generated from example definition: specification/hybridconnectivity/resource-manager/Microsoft.HybridConnectivity/preview/2021-10-06-preview/examples/EndpointsPatchDefault.json
            // this example is just showing the usage of "Endpoints_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EndpointResource created on azure
            // for more information of creating EndpointResource, please refer to the document of EndpointResource
            string scope = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine";
            string endpointName = "default";
            ResourceIdentifier endpointResourceId = EndpointResource.CreateResourceIdentifier(scope, endpointName);
            EndpointResource endpointResource = client.GetEndpointResource(endpointResourceId);

            // invoke the operation
            EndpointResourceData data = new EndpointResourceData()
            {
                EndpointType = EndpointType.Default,
            };
            EndpointResource result = await endpointResource.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EndpointResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // HybridConnectivityEndpointsDeleteDefault
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_HybridConnectivityEndpointsDeleteDefault()
        {
            // Generated from example definition: specification/hybridconnectivity/resource-manager/Microsoft.HybridConnectivity/preview/2021-10-06-preview/examples/EndpointsDeleteDefault.json
            // this example is just showing the usage of "Endpoints_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EndpointResource created on azure
            // for more information of creating EndpointResource, please refer to the document of EndpointResource
            string scope = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine";
            string endpointName = "default";
            ResourceIdentifier endpointResourceId = EndpointResource.CreateResourceIdentifier(scope, endpointName);
            EndpointResource endpointResource = client.GetEndpointResource(endpointResourceId);

            // invoke the operation
            await endpointResource.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // HybridConnectivityEndpointsPostListCredentials
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetCredentials_HybridConnectivityEndpointsPostListCredentials()
        {
            // Generated from example definition: specification/hybridconnectivity/resource-manager/Microsoft.HybridConnectivity/preview/2021-10-06-preview/examples/EndpointsPostListCredentials.json
            // this example is just showing the usage of "Endpoints_ListCredentials" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EndpointResource created on azure
            // for more information of creating EndpointResource, please refer to the document of EndpointResource
            string scope = "subscriptions/f5bcc1d9-23af-4ae9-aca1-041d0f593a63/resourceGroups/hybridRG/providers/Microsoft.HybridCompute/machines/testMachine";
            string endpointName = "default";
            ResourceIdentifier endpointResourceId = EndpointResource.CreateResourceIdentifier(scope, endpointName);
            EndpointResource endpointResource = client.GetEndpointResource(endpointResourceId);

            // invoke the operation
            long? expiresin = 10800L;
            TargetResourceEndpointAccess result = await endpointResource.GetCredentialsAsync(expiresin: expiresin);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
