// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.HybridCompute.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.HybridCompute
{
    /// <summary>
    /// A class representing the NetworkSecurityPerimeterConfiguration data model.
    /// Properties that define a Network Security Perimeter resource.
    /// </summary>
    public partial class NetworkSecurityPerimeterConfigurationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigurationData"/>. </summary>
        internal NetworkSecurityPerimeterConfigurationData()
        {
            ProvisioningIssues = new ChangeTrackingList<HybridComputeProvisioningIssue>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Current state of this NetworkSecurityPerimeter: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed. </param>
        /// <param name="provisioningIssues"> Provisioning issues. </param>
        /// <param name="networkSecurityPerimeter"> The Network Security Perimeter associated with this configuration. </param>
        /// <param name="resourceAssociation"> The Resource Association. </param>
        /// <param name="profile"> Network Security Perimeter profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkSecurityPerimeterConfigurationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string provisioningState, IReadOnlyList<HybridComputeProvisioningIssue> provisioningIssues, NetworkSecurityPerimeter networkSecurityPerimeter, HybridComputeResourceAssociation resourceAssociation, NetworkSecurityPerimeterProfile profile, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            ProvisioningIssues = provisioningIssues;
            NetworkSecurityPerimeter = networkSecurityPerimeter;
            ResourceAssociation = resourceAssociation;
            Profile = profile;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Current state of this NetworkSecurityPerimeter: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed. </summary>
        [WirePath("properties.provisioningState")]
        public string ProvisioningState { get; }
        /// <summary> Provisioning issues. </summary>
        [WirePath("properties.provisioningIssues")]
        public IReadOnlyList<HybridComputeProvisioningIssue> ProvisioningIssues { get; }
        /// <summary> The Network Security Perimeter associated with this configuration. </summary>
        [WirePath("properties.networkSecurityPerimeter")]
        public NetworkSecurityPerimeter NetworkSecurityPerimeter { get; }
        /// <summary> The Resource Association. </summary>
        [WirePath("properties.resourceAssociation")]
        public HybridComputeResourceAssociation ResourceAssociation { get; }
        /// <summary> Network Security Perimeter profile. </summary>
        [WirePath("properties.profile")]
        public NetworkSecurityPerimeterProfile Profile { get; }
    }
}
