// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> The VolumeLicenseDetails. </summary>
    public partial class VolumeLicenseDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VolumeLicenseDetails"/>. </summary>
        public VolumeLicenseDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VolumeLicenseDetails"/>. </summary>
        /// <param name="programYear"> Describes the program year the volume license is for. </param>
        /// <param name="invoiceId"> The invoice id for the volume license. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VolumeLicenseDetails(HybridComputeProgramYear? programYear, string invoiceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProgramYear = programYear;
            InvoiceId = invoiceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Describes the program year the volume license is for. </summary>
        [WirePath("programYear")]
        public HybridComputeProgramYear? ProgramYear { get; set; }
        /// <summary> The invoice id for the volume license. </summary>
        [WirePath("invoiceId")]
        public string InvoiceId { get; set; }
    }
}
