// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> The VmGuestPatchClassificationWindow. </summary>
    public readonly partial struct VmGuestPatchClassificationWindow : IEquatable<VmGuestPatchClassificationWindow>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VmGuestPatchClassificationWindow"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VmGuestPatchClassificationWindow(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CriticalValue = "Critical";
        private const string SecurityValue = "Security";
        private const string UpdateRollUpValue = "UpdateRollUp";
        private const string FeaturePackValue = "FeaturePack";
        private const string ServicePackValue = "ServicePack";
        private const string DefinitionValue = "Definition";
        private const string ToolsValue = "Tools";
        private const string UpdatesValue = "Updates";

        /// <summary> Critical. </summary>
        public static VmGuestPatchClassificationWindow Critical { get; } = new VmGuestPatchClassificationWindow(CriticalValue);
        /// <summary> Security. </summary>
        public static VmGuestPatchClassificationWindow Security { get; } = new VmGuestPatchClassificationWindow(SecurityValue);
        /// <summary> UpdateRollUp. </summary>
        public static VmGuestPatchClassificationWindow UpdateRollUp { get; } = new VmGuestPatchClassificationWindow(UpdateRollUpValue);
        /// <summary> FeaturePack. </summary>
        public static VmGuestPatchClassificationWindow FeaturePack { get; } = new VmGuestPatchClassificationWindow(FeaturePackValue);
        /// <summary> ServicePack. </summary>
        public static VmGuestPatchClassificationWindow ServicePack { get; } = new VmGuestPatchClassificationWindow(ServicePackValue);
        /// <summary> Definition. </summary>
        public static VmGuestPatchClassificationWindow Definition { get; } = new VmGuestPatchClassificationWindow(DefinitionValue);
        /// <summary> Tools. </summary>
        public static VmGuestPatchClassificationWindow Tools { get; } = new VmGuestPatchClassificationWindow(ToolsValue);
        /// <summary> Updates. </summary>
        public static VmGuestPatchClassificationWindow Updates { get; } = new VmGuestPatchClassificationWindow(UpdatesValue);
        /// <summary> Determines if two <see cref="VmGuestPatchClassificationWindow"/> values are the same. </summary>
        public static bool operator ==(VmGuestPatchClassificationWindow left, VmGuestPatchClassificationWindow right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VmGuestPatchClassificationWindow"/> values are not the same. </summary>
        public static bool operator !=(VmGuestPatchClassificationWindow left, VmGuestPatchClassificationWindow right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VmGuestPatchClassificationWindow"/>. </summary>
        public static implicit operator VmGuestPatchClassificationWindow(string value) => new VmGuestPatchClassificationWindow(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VmGuestPatchClassificationWindow other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VmGuestPatchClassificationWindow other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
