// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> The VmGuestPatchClassificationLinux. </summary>
    public readonly partial struct VmGuestPatchClassificationLinux : IEquatable<VmGuestPatchClassificationLinux>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VmGuestPatchClassificationLinux"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VmGuestPatchClassificationLinux(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CriticalValue = "Critical";
        private const string SecurityValue = "Security";
        private const string OtherValue = "Other";

        /// <summary> Critical. </summary>
        public static VmGuestPatchClassificationLinux Critical { get; } = new VmGuestPatchClassificationLinux(CriticalValue);
        /// <summary> Security. </summary>
        public static VmGuestPatchClassificationLinux Security { get; } = new VmGuestPatchClassificationLinux(SecurityValue);
        /// <summary> Other. </summary>
        public static VmGuestPatchClassificationLinux Other { get; } = new VmGuestPatchClassificationLinux(OtherValue);
        /// <summary> Determines if two <see cref="VmGuestPatchClassificationLinux"/> values are the same. </summary>
        public static bool operator ==(VmGuestPatchClassificationLinux left, VmGuestPatchClassificationLinux right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VmGuestPatchClassificationLinux"/> values are not the same. </summary>
        public static bool operator !=(VmGuestPatchClassificationLinux left, VmGuestPatchClassificationLinux right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VmGuestPatchClassificationLinux"/>. </summary>
        public static implicit operator VmGuestPatchClassificationLinux(string value) => new VmGuestPatchClassificationLinux(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VmGuestPatchClassificationLinux other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VmGuestPatchClassificationLinux other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
