// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Specifies the patch service used for the operation. </summary>
    public readonly partial struct PatchServiceUsed : IEquatable<PatchServiceUsed>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PatchServiceUsed"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PatchServiceUsed(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string WUValue = "WU";
        private const string WUWsusValue = "WU_WSUS";
        private const string YumValue = "YUM";
        private const string AptValue = "APT";
        private const string ZypperValue = "Zypper";

        /// <summary> Unknown. </summary>
        public static PatchServiceUsed Unknown { get; } = new PatchServiceUsed(UnknownValue);
        /// <summary> WU. </summary>
        public static PatchServiceUsed WU { get; } = new PatchServiceUsed(WUValue);
        /// <summary> WU_WSUS. </summary>
        public static PatchServiceUsed WUWsus { get; } = new PatchServiceUsed(WUWsusValue);
        /// <summary> YUM. </summary>
        public static PatchServiceUsed Yum { get; } = new PatchServiceUsed(YumValue);
        /// <summary> APT. </summary>
        public static PatchServiceUsed Apt { get; } = new PatchServiceUsed(AptValue);
        /// <summary> Zypper. </summary>
        public static PatchServiceUsed Zypper { get; } = new PatchServiceUsed(ZypperValue);
        /// <summary> Determines if two <see cref="PatchServiceUsed"/> values are the same. </summary>
        public static bool operator ==(PatchServiceUsed left, PatchServiceUsed right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PatchServiceUsed"/> values are not the same. </summary>
        public static bool operator !=(PatchServiceUsed left, PatchServiceUsed right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PatchServiceUsed"/>. </summary>
        public static implicit operator PatchServiceUsed(string value) => new PatchServiceUsed(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PatchServiceUsed other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PatchServiceUsed other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
