// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Indicates if operation was triggered by user or by platform. </summary>
    public readonly partial struct PatchOperationStartedBy : IEquatable<PatchOperationStartedBy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PatchOperationStartedBy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PatchOperationStartedBy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserValue = "User";
        private const string PlatformValue = "Platform";

        /// <summary> User. </summary>
        public static PatchOperationStartedBy User { get; } = new PatchOperationStartedBy(UserValue);
        /// <summary> Platform. </summary>
        public static PatchOperationStartedBy Platform { get; } = new PatchOperationStartedBy(PlatformValue);
        /// <summary> Determines if two <see cref="PatchOperationStartedBy"/> values are the same. </summary>
        public static bool operator ==(PatchOperationStartedBy left, PatchOperationStartedBy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PatchOperationStartedBy"/> values are not the same. </summary>
        public static bool operator !=(PatchOperationStartedBy left, PatchOperationStartedBy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PatchOperationStartedBy"/>. </summary>
        public static implicit operator PatchOperationStartedBy(string value) => new PatchOperationStartedBy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PatchOperationStartedBy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PatchOperationStartedBy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
