// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Specifies the patch mode. </summary>
    public readonly partial struct PatchModeType : IEquatable<PatchModeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PatchModeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PatchModeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ImageDefaultValue = "ImageDefault";
        private const string AutomaticByPlatformValue = "AutomaticByPlatform";
        private const string AutomaticByOSValue = "AutomaticByOS";
        private const string ManualValue = "Manual";

        /// <summary> ImageDefault. </summary>
        public static PatchModeType ImageDefault { get; } = new PatchModeType(ImageDefaultValue);
        /// <summary> AutomaticByPlatform. </summary>
        public static PatchModeType AutomaticByPlatform { get; } = new PatchModeType(AutomaticByPlatformValue);
        /// <summary> AutomaticByOS. </summary>
        public static PatchModeType AutomaticByOS { get; } = new PatchModeType(AutomaticByOSValue);
        /// <summary> Manual. </summary>
        public static PatchModeType Manual { get; } = new PatchModeType(ManualValue);
        /// <summary> Determines if two <see cref="PatchModeType"/> values are the same. </summary>
        public static bool operator ==(PatchModeType left, PatchModeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PatchModeType"/> values are not the same. </summary>
        public static bool operator !=(PatchModeType left, PatchModeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PatchModeType"/>. </summary>
        public static implicit operator PatchModeType(string value) => new PatchModeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PatchModeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PatchModeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
