// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Properties that define a Network Security Perimeter resource. </summary>
    public partial class NetworkSecurityPerimeter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeter"/>. </summary>
        internal NetworkSecurityPerimeter()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeter"/>. </summary>
        /// <param name="id"> Azure resource Id. </param>
        /// <param name="perimeterGuid"> Guid of the Network Security Perimeter. </param>
        /// <param name="location"> Regional location of the perimeter. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkSecurityPerimeter(string id, string perimeterGuid, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            PerimeterGuid = perimeterGuid;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Azure resource Id. </summary>
        [WirePath("id")]
        public string Id { get; }
        /// <summary> Guid of the Network Security Perimeter. </summary>
        [WirePath("perimeterGuid")]
        public string PerimeterGuid { get; }
        /// <summary> Regional location of the perimeter. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; }
    }
}
