// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Subscription status of the OS or Product feature. </summary>
    public readonly partial struct LicenseProfileSubscriptionStatus : IEquatable<LicenseProfileSubscriptionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LicenseProfileSubscriptionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LicenseProfileSubscriptionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string EnablingValue = "Enabling";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string DisablingValue = "Disabling";
        private const string FailedValue = "Failed";

        /// <summary> Unknown. </summary>
        public static LicenseProfileSubscriptionStatus Unknown { get; } = new LicenseProfileSubscriptionStatus(UnknownValue);
        /// <summary> Enabling. </summary>
        public static LicenseProfileSubscriptionStatus Enabling { get; } = new LicenseProfileSubscriptionStatus(EnablingValue);
        /// <summary> Enabled. </summary>
        public static LicenseProfileSubscriptionStatus Enabled { get; } = new LicenseProfileSubscriptionStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static LicenseProfileSubscriptionStatus Disabled { get; } = new LicenseProfileSubscriptionStatus(DisabledValue);
        /// <summary> Disabling. </summary>
        public static LicenseProfileSubscriptionStatus Disabling { get; } = new LicenseProfileSubscriptionStatus(DisablingValue);
        /// <summary> Failed. </summary>
        public static LicenseProfileSubscriptionStatus Failed { get; } = new LicenseProfileSubscriptionStatus(FailedValue);
        /// <summary> Determines if two <see cref="LicenseProfileSubscriptionStatus"/> values are the same. </summary>
        public static bool operator ==(LicenseProfileSubscriptionStatus left, LicenseProfileSubscriptionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LicenseProfileSubscriptionStatus"/> values are not the same. </summary>
        public static bool operator !=(LicenseProfileSubscriptionStatus left, LicenseProfileSubscriptionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LicenseProfileSubscriptionStatus"/>. </summary>
        public static implicit operator LicenseProfileSubscriptionStatus(string value) => new LicenseProfileSubscriptionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LicenseProfileSubscriptionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LicenseProfileSubscriptionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
