// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Properties for the Machine ESU profile. </summary>
    public partial class LicenseProfileMachineInstanceViewEsuProperties : LicenseProfileArmEsuPropertiesWithoutAssignedLicense
    {
        /// <summary> Initializes a new instance of <see cref="LicenseProfileMachineInstanceViewEsuProperties"/>. </summary>
        public LicenseProfileMachineInstanceViewEsuProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LicenseProfileMachineInstanceViewEsuProperties"/>. </summary>
        /// <param name="assignedLicenseImmutableId"> The guid id of the license. </param>
        /// <param name="esuKeys"> The list of ESU keys. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="serverType"> The type of the Esu servers. </param>
        /// <param name="esuEligibility"> Indicates the eligibility state of Esu. </param>
        /// <param name="esuKeyState"> Indicates whether there is an ESU Key currently active for the machine. </param>
        /// <param name="assignedLicense"> The assigned license resource. </param>
        /// <param name="licenseAssignmentState"> Describes the license assignment state (Assigned or NotAssigned). </param>
        internal LicenseProfileMachineInstanceViewEsuProperties(Guid? assignedLicenseImmutableId, IReadOnlyList<EsuKey> esuKeys, IDictionary<string, BinaryData> serializedAdditionalRawData, EsuServerType? serverType, EsuEligibility? esuEligibility, EsuKeyState? esuKeyState, HybridComputeLicenseData assignedLicense, LicenseAssignmentState? licenseAssignmentState) : base(assignedLicenseImmutableId, esuKeys, serializedAdditionalRawData, serverType, esuEligibility, esuKeyState)
        {
            AssignedLicense = assignedLicense;
            LicenseAssignmentState = licenseAssignmentState;
        }

        /// <summary> The assigned license resource. </summary>
        [WirePath("assignedLicense")]
        public HybridComputeLicenseData AssignedLicense { get; set; }
        /// <summary> Describes the license assignment state (Assigned or NotAssigned). </summary>
        [WirePath("licenseAssignmentState")]
        public LicenseAssignmentState? LicenseAssignmentState { get; set; }
    }
}
