// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Describes the license core type (pCore or vCore). </summary>
    public readonly partial struct LicenseCoreType : IEquatable<LicenseCoreType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LicenseCoreType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LicenseCoreType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PCoreValue = "pCore";
        private const string VCoreValue = "vCore";

        /// <summary> pCore. </summary>
        public static LicenseCoreType PCore { get; } = new LicenseCoreType(PCoreValue);
        /// <summary> vCore. </summary>
        public static LicenseCoreType VCore { get; } = new LicenseCoreType(VCoreValue);
        /// <summary> Determines if two <see cref="LicenseCoreType"/> values are the same. </summary>
        public static bool operator ==(LicenseCoreType left, LicenseCoreType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LicenseCoreType"/> values are not the same. </summary>
        public static bool operator !=(LicenseCoreType left, LicenseCoreType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LicenseCoreType"/>. </summary>
        public static implicit operator LicenseCoreType(string value) => new LicenseCoreType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LicenseCoreType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LicenseCoreType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
