// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Describes the license assignment state (Assigned or NotAssigned). </summary>
    public readonly partial struct LicenseAssignmentState : IEquatable<LicenseAssignmentState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LicenseAssignmentState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LicenseAssignmentState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AssignedValue = "Assigned";
        private const string NotAssignedValue = "NotAssigned";

        /// <summary> Assigned. </summary>
        public static LicenseAssignmentState Assigned { get; } = new LicenseAssignmentState(AssignedValue);
        /// <summary> NotAssigned. </summary>
        public static LicenseAssignmentState NotAssigned { get; } = new LicenseAssignmentState(NotAssignedValue);
        /// <summary> Determines if two <see cref="LicenseAssignmentState"/> values are the same. </summary>
        public static bool operator ==(LicenseAssignmentState left, LicenseAssignmentState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LicenseAssignmentState"/> values are not the same. </summary>
        public static bool operator !=(LicenseAssignmentState left, LicenseAssignmentState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LicenseAssignmentState"/>. </summary>
        public static implicit operator LicenseAssignmentState(string value) => new LicenseAssignmentState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LicenseAssignmentState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LicenseAssignmentState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
