// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Specifies the status of Agent Upgrade. </summary>
    public readonly partial struct LastAttemptStatusEnum : IEquatable<LastAttemptStatusEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LastAttemptStatusEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LastAttemptStatusEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SuccessValue = "Success";
        private const string FailedValue = "Failed";

        /// <summary> Success. </summary>
        public static LastAttemptStatusEnum Success { get; } = new LastAttemptStatusEnum(SuccessValue);
        /// <summary> Failed. </summary>
        public static LastAttemptStatusEnum Failed { get; } = new LastAttemptStatusEnum(FailedValue);
        /// <summary> Determines if two <see cref="LastAttemptStatusEnum"/> values are the same. </summary>
        public static bool operator ==(LastAttemptStatusEnum left, LastAttemptStatusEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LastAttemptStatusEnum"/> values are not the same. </summary>
        public static bool operator !=(LastAttemptStatusEnum left, LastAttemptStatusEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LastAttemptStatusEnum"/>. </summary>
        public static implicit operator LastAttemptStatusEnum(string value) => new LastAttemptStatusEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LastAttemptStatusEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LastAttemptStatusEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
