// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Input for InstallPatches on a Windows VM, as directly received by the API. </summary>
    public partial class HybridComputeWindowsParameters
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridComputeWindowsParameters"/>. </summary>
        public HybridComputeWindowsParameters()
        {
            ClassificationsToInclude = new ChangeTrackingList<VmGuestPatchClassificationWindow>();
            KbNumbersToInclude = new ChangeTrackingList<string>();
            KbNumbersToExclude = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputeWindowsParameters"/>. </summary>
        /// <param name="classificationsToInclude"> The update classifications to select when installing patches for Windows. </param>
        /// <param name="kbNumbersToInclude"> Kbs to include in the patch operation. </param>
        /// <param name="kbNumbersToExclude"> Kbs to exclude in the patch operation. </param>
        /// <param name="excludeKbsRequiringReboot"> Filters out Kbs that don't have an InstallationRebootBehavior of 'NeverReboots' when this is set to true. </param>
        /// <param name="maxPatchPublishOn"> This is used to install patches that were published on or before this given max published date. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridComputeWindowsParameters(IList<VmGuestPatchClassificationWindow> classificationsToInclude, IList<string> kbNumbersToInclude, IList<string> kbNumbersToExclude, bool? excludeKbsRequiringReboot, DateTimeOffset? maxPatchPublishOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClassificationsToInclude = classificationsToInclude;
            KbNumbersToInclude = kbNumbersToInclude;
            KbNumbersToExclude = kbNumbersToExclude;
            ExcludeKbsRequiringReboot = excludeKbsRequiringReboot;
            MaxPatchPublishOn = maxPatchPublishOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The update classifications to select when installing patches for Windows. </summary>
        [WirePath("classificationsToInclude")]
        public IList<VmGuestPatchClassificationWindow> ClassificationsToInclude { get; }
        /// <summary> Kbs to include in the patch operation. </summary>
        [WirePath("kbNumbersToInclude")]
        public IList<string> KbNumbersToInclude { get; }
        /// <summary> Kbs to exclude in the patch operation. </summary>
        [WirePath("kbNumbersToExclude")]
        public IList<string> KbNumbersToExclude { get; }
        /// <summary> Filters out Kbs that don't have an InstallationRebootBehavior of 'NeverReboots' when this is set to true. </summary>
        [WirePath("excludeKbsRequiringReboot")]
        public bool? ExcludeKbsRequiringReboot { get; set; }
        /// <summary> This is used to install patches that were published on or before this given max published date. </summary>
        [WirePath("maxPatchPublishDate")]
        public DateTimeOffset? MaxPatchPublishOn { get; set; }
    }
}
