// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> The level code. </summary>
    public readonly partial struct HybridComputeStatusLevelType : IEquatable<HybridComputeStatusLevelType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridComputeStatusLevelType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridComputeStatusLevelType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InfoValue = "Info";
        private const string WarningValue = "Warning";
        private const string ErrorValue = "Error";

        /// <summary> Info. </summary>
        public static HybridComputeStatusLevelType Info { get; } = new HybridComputeStatusLevelType(InfoValue);
        /// <summary> Warning. </summary>
        public static HybridComputeStatusLevelType Warning { get; } = new HybridComputeStatusLevelType(WarningValue);
        /// <summary> Error. </summary>
        public static HybridComputeStatusLevelType Error { get; } = new HybridComputeStatusLevelType(ErrorValue);
        /// <summary> Determines if two <see cref="HybridComputeStatusLevelType"/> values are the same. </summary>
        public static bool operator ==(HybridComputeStatusLevelType left, HybridComputeStatusLevelType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridComputeStatusLevelType"/> values are not the same. </summary>
        public static bool operator !=(HybridComputeStatusLevelType left, HybridComputeStatusLevelType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridComputeStatusLevelType"/>. </summary>
        public static implicit operator HybridComputeStatusLevelType(string value) => new HybridComputeStatusLevelType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridComputeStatusLevelType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridComputeStatusLevelType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
