// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Describes the status and behavior of a service. </summary>
    public partial class HybridComputeServiceStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridComputeServiceStatus"/>. </summary>
        public HybridComputeServiceStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputeServiceStatus"/>. </summary>
        /// <param name="status"> The current status of the service. </param>
        /// <param name="startupType"> The behavior of the service when the Arc-enabled machine starts up. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridComputeServiceStatus(string status, string startupType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            StartupType = startupType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The current status of the service. </summary>
        [WirePath("status")]
        public string Status { get; set; }
        /// <summary> The behavior of the service when the Arc-enabled machine starts up. </summary>
        [WirePath("startupType")]
        public string StartupType { get; set; }
    }
}
