// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> The network access policy to determine if Azure Arc agents can use public Azure Arc service endpoints. Defaults to disabled (access to Azure Arc services only via private link). </summary>
    public readonly partial struct HybridComputePublicNetworkAccessType : IEquatable<HybridComputePublicNetworkAccessType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridComputePublicNetworkAccessType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridComputePublicNetworkAccessType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string SecuredByPerimeterValue = "SecuredByPerimeter";

        /// <summary> Allows Azure Arc agents to communicate with Azure Arc services over both public (internet) and private endpoints. </summary>
        public static HybridComputePublicNetworkAccessType Enabled { get; } = new HybridComputePublicNetworkAccessType(EnabledValue);
        /// <summary> Does not allow Azure Arc agents to communicate with Azure Arc services over public (internet) endpoints. The agents must use the private link. </summary>
        public static HybridComputePublicNetworkAccessType Disabled { get; } = new HybridComputePublicNetworkAccessType(DisabledValue);
        /// <summary> Azure Arc agent communication with Azure Arc services over public (internet) is enforced by Network Security Perimeter (NSP). </summary>
        public static HybridComputePublicNetworkAccessType SecuredByPerimeter { get; } = new HybridComputePublicNetworkAccessType(SecuredByPerimeterValue);
        /// <summary> Determines if two <see cref="HybridComputePublicNetworkAccessType"/> values are the same. </summary>
        public static bool operator ==(HybridComputePublicNetworkAccessType left, HybridComputePublicNetworkAccessType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridComputePublicNetworkAccessType"/> values are not the same. </summary>
        public static bool operator !=(HybridComputePublicNetworkAccessType left, HybridComputePublicNetworkAccessType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridComputePublicNetworkAccessType"/>. </summary>
        public static implicit operator HybridComputePublicNetworkAccessType(string value) => new HybridComputePublicNetworkAccessType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridComputePublicNetworkAccessType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridComputePublicNetworkAccessType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
