// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Describes the program year the volume license is for. </summary>
    public readonly partial struct HybridComputeProgramYear : IEquatable<HybridComputeProgramYear>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridComputeProgramYear"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridComputeProgramYear(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Year1Value = "Year 1";
        private const string Year2Value = "Year 2";
        private const string Year3Value = "Year 3";

        /// <summary> Year 1. </summary>
        public static HybridComputeProgramYear Year1 { get; } = new HybridComputeProgramYear(Year1Value);
        /// <summary> Year 2. </summary>
        public static HybridComputeProgramYear Year2 { get; } = new HybridComputeProgramYear(Year2Value);
        /// <summary> Year 3. </summary>
        public static HybridComputeProgramYear Year3 { get; } = new HybridComputeProgramYear(Year3Value);
        /// <summary> Determines if two <see cref="HybridComputeProgramYear"/> values are the same. </summary>
        public static bool operator ==(HybridComputeProgramYear left, HybridComputeProgramYear right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridComputeProgramYear"/> values are not the same. </summary>
        public static bool operator !=(HybridComputeProgramYear left, HybridComputeProgramYear right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridComputeProgramYear"/>. </summary>
        public static implicit operator HybridComputeProgramYear(string value) => new HybridComputeProgramYear(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridComputeProgramYear other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridComputeProgramYear other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
