// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Product Feature. </summary>
    public partial class HybridComputeProductFeatureUpdate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridComputeProductFeatureUpdate"/>. </summary>
        public HybridComputeProductFeatureUpdate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputeProductFeatureUpdate"/>. </summary>
        /// <param name="name"> Product feature name. </param>
        /// <param name="subscriptionStatus"> Indicates the new status of the product feature. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridComputeProductFeatureUpdate(string name, LicenseProfileSubscriptionStatusUpdate? subscriptionStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            SubscriptionStatus = subscriptionStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Product feature name. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Indicates the new status of the product feature. </summary>
        [WirePath("subscriptionStatus")]
        public LicenseProfileSubscriptionStatusUpdate? SubscriptionStatus { get; set; }
    }
}
