// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Status of the hotpatch capability enrollment or disenrollment. </summary>
    public partial class HybridComputePatchSettingsStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridComputePatchSettingsStatus"/>. </summary>
        internal HybridComputePatchSettingsStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputePatchSettingsStatus"/>. </summary>
        /// <param name="hotpatchEnablementStatus"> Indicates the current status of the hotpatch being enabled or disabled. </param>
        /// <param name="error"> The errors that were encountered during the hotpatch capability enrollment or disenrollment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridComputePatchSettingsStatus(HotpatchEnablementStatus? hotpatchEnablementStatus, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            HotpatchEnablementStatus = hotpatchEnablementStatus;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Indicates the current status of the hotpatch being enabled or disabled. </summary>
        [WirePath("hotpatchEnablementStatus")]
        public HotpatchEnablementStatus? HotpatchEnablementStatus { get; }
        /// <summary> The errors that were encountered during the hotpatch capability enrollment or disenrollment. </summary>
        [WirePath("error")]
        public ResponseError Error { get; }
    }
}
