// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> The operating system type of the machine. </summary>
    public readonly partial struct HybridComputeOSType : IEquatable<HybridComputeOSType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridComputeOSType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridComputeOSType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WindowsValue = "Windows";
        private const string LinuxValue = "Linux";

        /// <summary> Windows. </summary>
        public static HybridComputeOSType Windows { get; } = new HybridComputeOSType(WindowsValue);
        /// <summary> Linux. </summary>
        public static HybridComputeOSType Linux { get; } = new HybridComputeOSType(LinuxValue);
        /// <summary> Determines if two <see cref="HybridComputeOSType"/> values are the same. </summary>
        public static bool operator ==(HybridComputeOSType left, HybridComputeOSType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridComputeOSType"/> values are not the same. </summary>
        public static bool operator !=(HybridComputeOSType left, HybridComputeOSType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridComputeOSType"/>. </summary>
        public static implicit operator HybridComputeOSType(string value) => new HybridComputeOSType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridComputeOSType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridComputeOSType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
