// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> The type of the license resource. </summary>
    public readonly partial struct HybridComputeLicenseType : IEquatable<HybridComputeLicenseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridComputeLicenseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridComputeLicenseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EsuValue = "ESU";

        /// <summary> ESU. </summary>
        public static HybridComputeLicenseType Esu { get; } = new HybridComputeLicenseType(EsuValue);
        /// <summary> Determines if two <see cref="HybridComputeLicenseType"/> values are the same. </summary>
        public static bool operator ==(HybridComputeLicenseType left, HybridComputeLicenseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridComputeLicenseType"/> values are not the same. </summary>
        public static bool operator !=(HybridComputeLicenseType left, HybridComputeLicenseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridComputeLicenseType"/>. </summary>
        public static implicit operator HybridComputeLicenseType(string value) => new HybridComputeLicenseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridComputeLicenseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridComputeLicenseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
