// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Describes the license target server. </summary>
    public readonly partial struct HybridComputeLicenseTarget : IEquatable<HybridComputeLicenseTarget>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridComputeLicenseTarget"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridComputeLicenseTarget(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WindowsServer2012Value = "Windows Server 2012";
        private const string WindowsServer2012R2Value = "Windows Server 2012 R2";

        /// <summary> Windows Server 2012. </summary>
        public static HybridComputeLicenseTarget WindowsServer2012 { get; } = new HybridComputeLicenseTarget(WindowsServer2012Value);
        /// <summary> Windows Server 2012 R2. </summary>
        public static HybridComputeLicenseTarget WindowsServer2012R2 { get; } = new HybridComputeLicenseTarget(WindowsServer2012R2Value);
        /// <summary> Determines if two <see cref="HybridComputeLicenseTarget"/> values are the same. </summary>
        public static bool operator ==(HybridComputeLicenseTarget left, HybridComputeLicenseTarget right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridComputeLicenseTarget"/> values are not the same. </summary>
        public static bool operator !=(HybridComputeLicenseTarget left, HybridComputeLicenseTarget right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridComputeLicenseTarget"/>. </summary>
        public static implicit operator HybridComputeLicenseTarget(string value) => new HybridComputeLicenseTarget(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridComputeLicenseTarget other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridComputeLicenseTarget other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
