// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Describes the state of the license. </summary>
    public readonly partial struct HybridComputeLicenseState : IEquatable<HybridComputeLicenseState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridComputeLicenseState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridComputeLicenseState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActivatedValue = "Activated";
        private const string DeactivatedValue = "Deactivated";

        /// <summary> Activated. </summary>
        public static HybridComputeLicenseState Activated { get; } = new HybridComputeLicenseState(ActivatedValue);
        /// <summary> Deactivated. </summary>
        public static HybridComputeLicenseState Deactivated { get; } = new HybridComputeLicenseState(DeactivatedValue);
        /// <summary> Determines if two <see cref="HybridComputeLicenseState"/> values are the same. </summary>
        public static bool operator ==(HybridComputeLicenseState left, HybridComputeLicenseState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridComputeLicenseState"/> values are not the same. </summary>
        public static bool operator !=(HybridComputeLicenseState left, HybridComputeLicenseState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridComputeLicenseState"/>. </summary>
        public static implicit operator HybridComputeLicenseState(string value) => new HybridComputeLicenseState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridComputeLicenseState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridComputeLicenseState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
