// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Describes a License Profile Update. </summary>
    public partial class HybridComputeLicenseProfilePatch : HybridComputeResourceUpdate
    {
        /// <summary> Initializes a new instance of <see cref="HybridComputeLicenseProfilePatch"/>. </summary>
        public HybridComputeLicenseProfilePatch()
        {
            ProductFeatures = new ChangeTrackingList<HybridComputeProductFeatureUpdate>();
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputeLicenseProfilePatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="subscriptionStatus"> Indicates the subscription status of the product. </param>
        /// <param name="productType"> Indicates the product type of the license. </param>
        /// <param name="productFeatures"> The list of product feature updates. </param>
        /// <param name="assignedLicense"> The resource id of the license. </param>
        /// <param name="softwareAssuranceCustomer"> Specifies if this machine is licensed as part of a Software Assurance agreement. </param>
        internal HybridComputeLicenseProfilePatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, LicenseProfileSubscriptionStatusUpdate? subscriptionStatus, LicenseProfileProductType? productType, IList<HybridComputeProductFeatureUpdate> productFeatures, string assignedLicense, bool? softwareAssuranceCustomer) : base(tags, serializedAdditionalRawData)
        {
            SubscriptionStatus = subscriptionStatus;
            ProductType = productType;
            ProductFeatures = productFeatures;
            AssignedLicense = assignedLicense;
            SoftwareAssuranceCustomer = softwareAssuranceCustomer;
        }

        /// <summary> Indicates the subscription status of the product. </summary>
        [WirePath("properties.subscriptionStatus")]
        public LicenseProfileSubscriptionStatusUpdate? SubscriptionStatus { get; set; }
        /// <summary> Indicates the product type of the license. </summary>
        [WirePath("properties.productType")]
        public LicenseProfileProductType? ProductType { get; set; }
        /// <summary> The list of product feature updates. </summary>
        [WirePath("properties.productFeatures")]
        public IList<HybridComputeProductFeatureUpdate> ProductFeatures { get; }
        /// <summary> The resource id of the license. </summary>
        [WirePath("properties.assignedLicense")]
        public string AssignedLicense { get; set; }
        /// <summary> Specifies if this machine is licensed as part of a Software Assurance agreement. </summary>
        [WirePath("properties.softwareAssuranceCustomer")]
        public bool? SoftwareAssuranceCustomer { get; set; }
    }
}
