// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Describes the properties of a License. </summary>
    public partial class HybridComputeLicenseDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridComputeLicenseDetails"/>. </summary>
        public HybridComputeLicenseDetails()
        {
            VolumeLicenseDetails = new ChangeTrackingList<VolumeLicenseDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputeLicenseDetails"/>. </summary>
        /// <param name="state"> Describes the state of the license. </param>
        /// <param name="target"> Describes the license target server. </param>
        /// <param name="edition"> Describes the edition of the license. The values are either Standard or Datacenter. </param>
        /// <param name="licenseCoreType"> Describes the license core type (pCore or vCore). </param>
        /// <param name="processors"> Describes the number of processors. </param>
        /// <param name="assignedLicenses"> Describes the number of assigned licenses. </param>
        /// <param name="immutableId"> Describes the immutable id. </param>
        /// <param name="volumeLicenseDetails"> A list of volume license details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridComputeLicenseDetails(HybridComputeLicenseState? state, HybridComputeLicenseTarget? target, HybridComputeLicenseEdition? edition, LicenseCoreType? licenseCoreType, int? processors, int? assignedLicenses, string immutableId, IList<VolumeLicenseDetails> volumeLicenseDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            State = state;
            Target = target;
            Edition = edition;
            LicenseCoreType = licenseCoreType;
            Processors = processors;
            AssignedLicenses = assignedLicenses;
            ImmutableId = immutableId;
            VolumeLicenseDetails = volumeLicenseDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Describes the state of the license. </summary>
        [WirePath("state")]
        public HybridComputeLicenseState? State { get; set; }
        /// <summary> Describes the license target server. </summary>
        [WirePath("target")]
        public HybridComputeLicenseTarget? Target { get; set; }
        /// <summary> Describes the edition of the license. The values are either Standard or Datacenter. </summary>
        [WirePath("edition")]
        public HybridComputeLicenseEdition? Edition { get; set; }
        /// <summary> Describes the license core type (pCore or vCore). </summary>
        [WirePath("type")]
        public LicenseCoreType? LicenseCoreType { get; set; }
        /// <summary> Describes the number of processors. </summary>
        [WirePath("processors")]
        public int? Processors { get; set; }
        /// <summary> Describes the number of assigned licenses. </summary>
        [WirePath("assignedLicenses")]
        public int? AssignedLicenses { get; }
        /// <summary> Describes the immutable id. </summary>
        [WirePath("immutableId")]
        public string ImmutableId { get; }
        /// <summary> A list of volume license details. </summary>
        [WirePath("volumeLicenseDetails")]
        public IList<VolumeLicenseDetails> VolumeLicenseDetails { get; }
    }
}
