// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HybridCompute.Models
{
    public partial class HybridComputeLicenseDetails : IUtf8JsonSerializable, IJsonModel<HybridComputeLicenseDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HybridComputeLicenseDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HybridComputeLicenseDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HybridComputeLicenseDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HybridComputeLicenseDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsDefined(Target))
            {
                writer.WritePropertyName("target"u8);
                writer.WriteStringValue(Target.Value.ToString());
            }
            if (Optional.IsDefined(Edition))
            {
                writer.WritePropertyName("edition"u8);
                writer.WriteStringValue(Edition.Value.ToString());
            }
            if (Optional.IsDefined(LicenseCoreType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(LicenseCoreType.Value.ToString());
            }
            if (Optional.IsDefined(Processors))
            {
                writer.WritePropertyName("processors"u8);
                writer.WriteNumberValue(Processors.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AssignedLicenses))
            {
                writer.WritePropertyName("assignedLicenses"u8);
                writer.WriteNumberValue(AssignedLicenses.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ImmutableId))
            {
                writer.WritePropertyName("immutableId"u8);
                writer.WriteStringValue(ImmutableId);
            }
            if (Optional.IsCollectionDefined(VolumeLicenseDetails))
            {
                writer.WritePropertyName("volumeLicenseDetails"u8);
                writer.WriteStartArray();
                foreach (var item in VolumeLicenseDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HybridComputeLicenseDetails IJsonModel<HybridComputeLicenseDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HybridComputeLicenseDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HybridComputeLicenseDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHybridComputeLicenseDetails(document.RootElement, options);
        }

        internal static HybridComputeLicenseDetails DeserializeHybridComputeLicenseDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            HybridComputeLicenseState? state = default;
            HybridComputeLicenseTarget? target = default;
            HybridComputeLicenseEdition? edition = default;
            LicenseCoreType? type = default;
            int? processors = default;
            int? assignedLicenses = default;
            string immutableId = default;
            IList<VolumeLicenseDetails> volumeLicenseDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new HybridComputeLicenseState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("target"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    target = new HybridComputeLicenseTarget(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("edition"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    edition = new HybridComputeLicenseEdition(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new LicenseCoreType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("processors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    processors = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("assignedLicenses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    assignedLicenses = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("immutableId"u8))
                {
                    immutableId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("volumeLicenseDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<VolumeLicenseDetails> array = new List<VolumeLicenseDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(Models.VolumeLicenseDetails.DeserializeVolumeLicenseDetails(item, options));
                    }
                    volumeLicenseDetails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HybridComputeLicenseDetails(
                state,
                target,
                edition,
                type,
                processors,
                assignedLicenses,
                immutableId,
                volumeLicenseDetails ?? new ChangeTrackingList<VolumeLicenseDetails>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(State), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  state: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(State))
                {
                    builder.Append("  state: ");
                    builder.AppendLine($"'{State.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Target), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  target: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Target))
                {
                    builder.Append("  target: ");
                    builder.AppendLine($"'{Target.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Edition), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  edition: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Edition))
                {
                    builder.Append("  edition: ");
                    builder.AppendLine($"'{Edition.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LicenseCoreType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  type: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LicenseCoreType))
                {
                    builder.Append("  type: ");
                    builder.AppendLine($"'{LicenseCoreType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Processors), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  processors: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Processors))
                {
                    builder.Append("  processors: ");
                    builder.AppendLine($"{Processors.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AssignedLicenses), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  assignedLicenses: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AssignedLicenses))
                {
                    builder.Append("  assignedLicenses: ");
                    builder.AppendLine($"{AssignedLicenses.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ImmutableId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  immutableId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ImmutableId))
                {
                    builder.Append("  immutableId: ");
                    if (ImmutableId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ImmutableId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ImmutableId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VolumeLicenseDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  volumeLicenseDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(VolumeLicenseDetails))
                {
                    if (VolumeLicenseDetails.Any())
                    {
                        builder.Append("  volumeLicenseDetails: ");
                        builder.AppendLine("[");
                        foreach (var item in VolumeLicenseDetails)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  volumeLicenseDetails: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HybridComputeLicenseDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HybridComputeLicenseDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HybridComputeLicenseDetails)} does not support writing '{options.Format}' format.");
            }
        }

        HybridComputeLicenseDetails IPersistableModel<HybridComputeLicenseDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HybridComputeLicenseDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHybridComputeLicenseDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HybridComputeLicenseDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HybridComputeLicenseDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
