// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Describes properties of the IP address. </summary>
    public partial class HybridComputeIPAddress
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridComputeIPAddress"/>. </summary>
        internal HybridComputeIPAddress()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputeIPAddress"/>. </summary>
        /// <param name="address"> Represents the IP Address. </param>
        /// <param name="ipAddressVersion"> Represents the Ip Address Version. </param>
        /// <param name="subnet"> The subnet to which this IP address belongs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridComputeIPAddress(string address, string ipAddressVersion, HybridComputeSubnet subnet, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Address = address;
            IPAddressVersion = ipAddressVersion;
            Subnet = subnet;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Represents the IP Address. </summary>
        [WirePath("address")]
        public string Address { get; }
        /// <summary> Represents the Ip Address Version. </summary>
        [WirePath("ipAddressVersion")]
        public string IPAddressVersion { get; }
        /// <summary> The subnet to which this IP address belongs. </summary>
        internal HybridComputeSubnet Subnet { get; }
        /// <summary> Represents address prefix. </summary>
        [WirePath("subnet.addressPrefix")]
        public string SubnetAddressPrefix
        {
            get => Subnet?.AddressPrefix;
        }
    }
}
