// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> The HybridComputeConnectionDetail. </summary>
    public partial class HybridComputeConnectionDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridComputeConnectionDetail"/>. </summary>
        internal HybridComputeConnectionDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputeConnectionDetail"/>. </summary>
        /// <param name="id"> Azure resource Id. </param>
        /// <param name="privateIPAddress"> The private endpoint connection private ip address. </param>
        /// <param name="linkIdentifier"> The private endpoint connection link identifier. </param>
        /// <param name="groupId"> The private endpoint connection group id. </param>
        /// <param name="memberName"> The private endpoint connection member name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridComputeConnectionDetail(ResourceIdentifier id, string privateIPAddress, string linkIdentifier, string groupId, string memberName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            PrivateIPAddress = privateIPAddress;
            LinkIdentifier = linkIdentifier;
            GroupId = groupId;
            MemberName = memberName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Azure resource Id. </summary>
        [WirePath("id")]
        public ResourceIdentifier Id { get; }
        /// <summary> The private endpoint connection private ip address. </summary>
        [WirePath("privateIpAddress")]
        public string PrivateIPAddress { get; }
        /// <summary> The private endpoint connection link identifier. </summary>
        [WirePath("linkIdentifier")]
        public string LinkIdentifier { get; }
        /// <summary> The private endpoint connection group id. </summary>
        [WirePath("groupId")]
        public string GroupId { get; }
        /// <summary> The private endpoint connection member name. </summary>
        [WirePath("memberName")]
        public string MemberName { get; }
    }
}
