// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Property that impacts a resource's logging behavior and its connectivity with other resources and public networks. </summary>
    public readonly partial struct HybridComputeAccessMode : IEquatable<HybridComputeAccessMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridComputeAccessMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridComputeAccessMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnforcedValue = "enforced";
        private const string AuditValue = "audit";
        private const string LearningValue = "learning";

        /// <summary> Indicates that resource access is controlled by the NSP definition. </summary>
        public static HybridComputeAccessMode Enforced { get; } = new HybridComputeAccessMode(EnforcedValue);
        /// <summary> Dry run mode, where traffic is evaluated against NSP Rules, logged but not enforced. </summary>
        public static HybridComputeAccessMode Audit { get; } = new HybridComputeAccessMode(AuditValue);
        /// <summary> Enables traffic evaluation to fall back to resource-specific firewall configurations. </summary>
        public static HybridComputeAccessMode Learning { get; } = new HybridComputeAccessMode(LearningValue);
        /// <summary> Determines if two <see cref="HybridComputeAccessMode"/> values are the same. </summary>
        public static bool operator ==(HybridComputeAccessMode left, HybridComputeAccessMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridComputeAccessMode"/> values are not the same. </summary>
        public static bool operator !=(HybridComputeAccessMode left, HybridComputeAccessMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridComputeAccessMode"/>. </summary>
        public static implicit operator HybridComputeAccessMode(string value) => new HybridComputeAccessMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridComputeAccessMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridComputeAccessMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
