// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Status of hotpatch enablement or disablement. </summary>
    public readonly partial struct HotpatchEnablementStatus : IEquatable<HotpatchEnablementStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HotpatchEnablementStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HotpatchEnablementStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PendingEvaluationValue = "PendingEvaluation";
        private const string DisabledValue = "Disabled";
        private const string ActionRequiredValue = "ActionRequired";
        private const string EnabledValue = "Enabled";

        /// <summary> Unknown. </summary>
        public static HotpatchEnablementStatus Unknown { get; } = new HotpatchEnablementStatus(UnknownValue);
        /// <summary> PendingEvaluation. </summary>
        public static HotpatchEnablementStatus PendingEvaluation { get; } = new HotpatchEnablementStatus(PendingEvaluationValue);
        /// <summary> Disabled. </summary>
        public static HotpatchEnablementStatus Disabled { get; } = new HotpatchEnablementStatus(DisabledValue);
        /// <summary> ActionRequired. </summary>
        public static HotpatchEnablementStatus ActionRequired { get; } = new HotpatchEnablementStatus(ActionRequiredValue);
        /// <summary> Enabled. </summary>
        public static HotpatchEnablementStatus Enabled { get; } = new HotpatchEnablementStatus(EnabledValue);
        /// <summary> Determines if two <see cref="HotpatchEnablementStatus"/> values are the same. </summary>
        public static bool operator ==(HotpatchEnablementStatus left, HotpatchEnablementStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HotpatchEnablementStatus"/> values are not the same. </summary>
        public static bool operator !=(HotpatchEnablementStatus left, HotpatchEnablementStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HotpatchEnablementStatus"/>. </summary>
        public static implicit operator HotpatchEnablementStatus(string value) => new HotpatchEnablementStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HotpatchEnablementStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HotpatchEnablementStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
