// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> The ESU key state. </summary>
    public readonly partial struct EsuKeyState : IEquatable<EsuKeyState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EsuKeyState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EsuKeyState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InactiveValue = "Inactive";
        private const string ActiveValue = "Active";

        /// <summary> Inactive. </summary>
        public static EsuKeyState Inactive { get; } = new EsuKeyState(InactiveValue);
        /// <summary> Active. </summary>
        public static EsuKeyState Active { get; } = new EsuKeyState(ActiveValue);
        /// <summary> Determines if two <see cref="EsuKeyState"/> values are the same. </summary>
        public static bool operator ==(EsuKeyState left, EsuKeyState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EsuKeyState"/> values are not the same. </summary>
        public static bool operator !=(EsuKeyState left, EsuKeyState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EsuKeyState"/>. </summary>
        public static implicit operator EsuKeyState(string value) => new EsuKeyState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EsuKeyState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EsuKeyState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
