// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> ESU key. </summary>
    public partial class EsuKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EsuKey"/>. </summary>
        internal EsuKey()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EsuKey"/>. </summary>
        /// <param name="sku"> SKU number. </param>
        /// <param name="licenseStatus"> The current status of the license profile key. Represented by the same integer value that is presented on the machine itself when querying the license key status. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EsuKey(string sku, int? licenseStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Sku = sku;
            LicenseStatus = licenseStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> SKU number. </summary>
        [WirePath("sku")]
        public string Sku { get; }
        /// <summary> The current status of the license profile key. Represented by the same integer value that is presented on the machine itself when querying the license key status. </summary>
        [WirePath("licenseStatus")]
        public int? LicenseStatus { get; }
    }
}
