// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> The ESU eligibility. </summary>
    public readonly partial struct EsuEligibility : IEquatable<EsuEligibility>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EsuEligibility"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EsuEligibility(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EligibleValue = "Eligible";
        private const string IneligibleValue = "Ineligible";
        private const string UnknownValue = "Unknown";

        /// <summary> Eligible. </summary>
        public static EsuEligibility Eligible { get; } = new EsuEligibility(EligibleValue);
        /// <summary> Ineligible. </summary>
        public static EsuEligibility Ineligible { get; } = new EsuEligibility(IneligibleValue);
        /// <summary> Unknown. </summary>
        public static EsuEligibility Unknown { get; } = new EsuEligibility(UnknownValue);
        /// <summary> Determines if two <see cref="EsuEligibility"/> values are the same. </summary>
        public static bool operator ==(EsuEligibility left, EsuEligibility right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EsuEligibility"/> values are not the same. </summary>
        public static bool operator !=(EsuEligibility left, EsuEligibility right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EsuEligibility"/>. </summary>
        public static implicit operator EsuEligibility(string value) => new EsuEligibility(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EsuEligibility other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EsuEligibility other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
