// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Summarization of patches available for installation on the machine by classification. </summary>
    public partial class AvailablePatchCountByClassification
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AvailablePatchCountByClassification"/>. </summary>
        internal AvailablePatchCountByClassification()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AvailablePatchCountByClassification"/>. </summary>
        /// <param name="security"> Number of security patches available for installation. </param>
        /// <param name="critical"> Number of critical patches available for installation. </param>
        /// <param name="definition"> Number of definition patches available for installation. </param>
        /// <param name="updateRollup"> Number of update Rollup patches available for installation. </param>
        /// <param name="featurePack"> Number of feature pack patches available for installation. </param>
        /// <param name="servicePack"> Number of service pack patches available for installation. </param>
        /// <param name="tools"> Number of tools patches available for installation. </param>
        /// <param name="updates"> Number of updates category patches available for installation. </param>
        /// <param name="other"> Number of other patches available for installation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvailablePatchCountByClassification(int? security, int? critical, int? definition, int? updateRollup, int? featurePack, int? servicePack, int? tools, int? updates, int? other, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Security = security;
            Critical = critical;
            Definition = definition;
            UpdateRollup = updateRollup;
            FeaturePack = featurePack;
            ServicePack = servicePack;
            Tools = tools;
            Updates = updates;
            Other = other;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Number of security patches available for installation. </summary>
        [WirePath("security")]
        public int? Security { get; }
        /// <summary> Number of critical patches available for installation. </summary>
        [WirePath("critical")]
        public int? Critical { get; }
        /// <summary> Number of definition patches available for installation. </summary>
        [WirePath("definition")]
        public int? Definition { get; }
        /// <summary> Number of update Rollup patches available for installation. </summary>
        [WirePath("updateRollup")]
        public int? UpdateRollup { get; }
        /// <summary> Number of feature pack patches available for installation. </summary>
        [WirePath("featurePack")]
        public int? FeaturePack { get; }
        /// <summary> Number of service pack patches available for installation. </summary>
        [WirePath("servicePack")]
        public int? ServicePack { get; }
        /// <summary> Number of tools patches available for installation. </summary>
        [WirePath("tools")]
        public int? Tools { get; }
        /// <summary> Number of updates category patches available for installation. </summary>
        [WirePath("updates")]
        public int? Updates { get; }
        /// <summary> Number of other patches available for installation. </summary>
        [WirePath("other")]
        public int? Other { get; }
    }
}
