// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HybridCompute.Models
{
    public partial class AvailablePatchCountByClassification : IUtf8JsonSerializable, IJsonModel<AvailablePatchCountByClassification>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AvailablePatchCountByClassification>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AvailablePatchCountByClassification>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvailablePatchCountByClassification>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AvailablePatchCountByClassification)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Security))
            {
                writer.WritePropertyName("security"u8);
                writer.WriteNumberValue(Security.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Critical))
            {
                writer.WritePropertyName("critical"u8);
                writer.WriteNumberValue(Critical.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Definition))
            {
                writer.WritePropertyName("definition"u8);
                writer.WriteNumberValue(Definition.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UpdateRollup))
            {
                writer.WritePropertyName("updateRollup"u8);
                writer.WriteNumberValue(UpdateRollup.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(FeaturePack))
            {
                writer.WritePropertyName("featurePack"u8);
                writer.WriteNumberValue(FeaturePack.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ServicePack))
            {
                writer.WritePropertyName("servicePack"u8);
                writer.WriteNumberValue(ServicePack.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Tools))
            {
                writer.WritePropertyName("tools"u8);
                writer.WriteNumberValue(Tools.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Updates))
            {
                writer.WritePropertyName("updates"u8);
                writer.WriteNumberValue(Updates.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Other))
            {
                writer.WritePropertyName("other"u8);
                writer.WriteNumberValue(Other.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AvailablePatchCountByClassification IJsonModel<AvailablePatchCountByClassification>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvailablePatchCountByClassification>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AvailablePatchCountByClassification)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAvailablePatchCountByClassification(document.RootElement, options);
        }

        internal static AvailablePatchCountByClassification DeserializeAvailablePatchCountByClassification(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? security = default;
            int? critical = default;
            int? definition = default;
            int? updateRollup = default;
            int? featurePack = default;
            int? servicePack = default;
            int? tools = default;
            int? updates = default;
            int? other = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("security"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    security = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("critical"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    critical = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("definition"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    definition = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("updateRollup"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    updateRollup = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("featurePack"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    featurePack = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("servicePack"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    servicePack = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("tools"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tools = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("updates"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    updates = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("other"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    other = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AvailablePatchCountByClassification(
                security,
                critical,
                definition,
                updateRollup,
                featurePack,
                servicePack,
                tools,
                updates,
                other,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Security), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  security: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Security))
                {
                    builder.Append("  security: ");
                    builder.AppendLine($"{Security.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Critical), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  critical: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Critical))
                {
                    builder.Append("  critical: ");
                    builder.AppendLine($"{Critical.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Definition), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  definition: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Definition))
                {
                    builder.Append("  definition: ");
                    builder.AppendLine($"{Definition.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UpdateRollup), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  updateRollup: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UpdateRollup))
                {
                    builder.Append("  updateRollup: ");
                    builder.AppendLine($"{UpdateRollup.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FeaturePack), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  featurePack: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FeaturePack))
                {
                    builder.Append("  featurePack: ");
                    builder.AppendLine($"{FeaturePack.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServicePack), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  servicePack: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ServicePack))
                {
                    builder.Append("  servicePack: ");
                    builder.AppendLine($"{ServicePack.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tools), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tools: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Tools))
                {
                    builder.Append("  tools: ");
                    builder.AppendLine($"{Tools.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Updates), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  updates: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Updates))
                {
                    builder.Append("  updates: ");
                    builder.AppendLine($"{Updates.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Other), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  other: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Other))
                {
                    builder.Append("  other: ");
                    builder.AppendLine($"{Other.Value}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<AvailablePatchCountByClassification>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvailablePatchCountByClassification>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(AvailablePatchCountByClassification)} does not support writing '{options.Format}' format.");
            }
        }

        AvailablePatchCountByClassification IPersistableModel<AvailablePatchCountByClassification>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AvailablePatchCountByClassification>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAvailablePatchCountByClassification(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AvailablePatchCountByClassification)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AvailablePatchCountByClassification>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
