// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Indicates which kind of Arc machine placement on-premises, such as HCI, SCVMM or VMware etc. </summary>
    public readonly partial struct ArcKindEnum : IEquatable<ArcKindEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ArcKindEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ArcKindEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AvsValue = "AVS";
        private const string HciValue = "HCI";
        private const string ScVmmValue = "SCVMM";
        private const string VMwareValue = "VMware";
        private const string EpsValue = "EPS";
        private const string GcpValue = "GCP";
        private const string AwsValue = "AWS";

        /// <summary> AVS. </summary>
        public static ArcKindEnum Avs { get; } = new ArcKindEnum(AvsValue);
        /// <summary> HCI. </summary>
        public static ArcKindEnum Hci { get; } = new ArcKindEnum(HciValue);
        /// <summary> SCVMM. </summary>
        public static ArcKindEnum ScVmm { get; } = new ArcKindEnum(ScVmmValue);
        /// <summary> VMware. </summary>
        public static ArcKindEnum VMware { get; } = new ArcKindEnum(VMwareValue);
        /// <summary> EPS. </summary>
        public static ArcKindEnum Eps { get; } = new ArcKindEnum(EpsValue);
        /// <summary> GCP. </summary>
        public static ArcKindEnum Gcp { get; } = new ArcKindEnum(GcpValue);
        /// <summary> AWS. </summary>
        public static ArcKindEnum Aws { get; } = new ArcKindEnum(AwsValue);
        /// <summary> Determines if two <see cref="ArcKindEnum"/> values are the same. </summary>
        public static bool operator ==(ArcKindEnum left, ArcKindEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ArcKindEnum"/> values are not the same. </summary>
        public static bool operator !=(ArcKindEnum left, ArcKindEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ArcKindEnum"/>. </summary>
        public static implicit operator ArcKindEnum(string value) => new ArcKindEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ArcKindEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ArcKindEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
