// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM. </summary>
    public partial class AgentConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AgentConfiguration"/>. </summary>
        internal AgentConfiguration()
        {
            IncomingConnectionsPorts = new ChangeTrackingList<string>();
            ExtensionsAllowList = new ChangeTrackingList<HybridComputeConfigurationExtension>();
            ExtensionsBlockList = new ChangeTrackingList<HybridComputeConfigurationExtension>();
            ProxyBypass = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AgentConfiguration"/>. </summary>
        /// <param name="proxyUri"> Specifies the URL of the proxy to be used. </param>
        /// <param name="incomingConnectionsPorts"> Specifies the list of ports that the agent will be able to listen on. </param>
        /// <param name="extensionsAllowList"> Array of extensions that are allowed to be installed or updated. </param>
        /// <param name="extensionsBlockList"> Array of extensions that are blocked (cannot be installed or updated). </param>
        /// <param name="proxyBypass"> List of service names which should not use the specified proxy server. </param>
        /// <param name="extensionsEnabled"> Specifies whether the extension service is enabled or disabled. </param>
        /// <param name="guestConfigurationEnabled"> Specified whether the guest configuration service is enabled or disabled. </param>
        /// <param name="configMode"> Name of configuration mode to use. Modes are pre-defined configurations of security controls, extension allowlists and guest configuration, maintained by Microsoft. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AgentConfiguration(Uri proxyUri, IReadOnlyList<string> incomingConnectionsPorts, IReadOnlyList<HybridComputeConfigurationExtension> extensionsAllowList, IReadOnlyList<HybridComputeConfigurationExtension> extensionsBlockList, IReadOnlyList<string> proxyBypass, string extensionsEnabled, string guestConfigurationEnabled, AgentConfigurationMode? configMode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProxyUri = proxyUri;
            IncomingConnectionsPorts = incomingConnectionsPorts;
            ExtensionsAllowList = extensionsAllowList;
            ExtensionsBlockList = extensionsBlockList;
            ProxyBypass = proxyBypass;
            ExtensionsEnabled = extensionsEnabled;
            GuestConfigurationEnabled = guestConfigurationEnabled;
            ConfigMode = configMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies the URL of the proxy to be used. </summary>
        [WirePath("proxyUrl")]
        public Uri ProxyUri { get; }
        /// <summary> Specifies the list of ports that the agent will be able to listen on. </summary>
        [WirePath("incomingConnectionsPorts")]
        public IReadOnlyList<string> IncomingConnectionsPorts { get; }
        /// <summary> Array of extensions that are allowed to be installed or updated. </summary>
        [WirePath("extensionsAllowList")]
        public IReadOnlyList<HybridComputeConfigurationExtension> ExtensionsAllowList { get; }
        /// <summary> Array of extensions that are blocked (cannot be installed or updated). </summary>
        [WirePath("extensionsBlockList")]
        public IReadOnlyList<HybridComputeConfigurationExtension> ExtensionsBlockList { get; }
        /// <summary> List of service names which should not use the specified proxy server. </summary>
        [WirePath("proxyBypass")]
        public IReadOnlyList<string> ProxyBypass { get; }
        /// <summary> Specifies whether the extension service is enabled or disabled. </summary>
        [WirePath("extensionsEnabled")]
        public string ExtensionsEnabled { get; }
        /// <summary> Specified whether the guest configuration service is enabled or disabled. </summary>
        [WirePath("guestConfigurationEnabled")]
        public string GuestConfigurationEnabled { get; }
        /// <summary> Name of configuration mode to use. Modes are pre-defined configurations of security controls, extension allowlists and guest configuration, maintained by Microsoft. </summary>
        [WirePath("configMode")]
        public AgentConfigurationMode? ConfigMode { get; }
    }
}
