// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridCompute
{
    internal class HybridComputePrivateEndpointConnectionOperationSource : IOperationSource<HybridComputePrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal HybridComputePrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        HybridComputePrivateEndpointConnectionResource IOperationSource<HybridComputePrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HybridComputePrivateEndpointConnectionData.DeserializeHybridComputePrivateEndpointConnectionData(document.RootElement);
            return new HybridComputePrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<HybridComputePrivateEndpointConnectionResource> IOperationSource<HybridComputePrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HybridComputePrivateEndpointConnectionData.DeserializeHybridComputePrivateEndpointConnectionData(document.RootElement);
            return new HybridComputePrivateEndpointConnectionResource(_client, data);
        }
    }
}
