// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridCompute
{
    internal class HybridComputeLicenseProfileOperationSource : IOperationSource<HybridComputeLicenseProfileResource>
    {
        private readonly ArmClient _client;

        internal HybridComputeLicenseProfileOperationSource(ArmClient client)
        {
            _client = client;
        }

        HybridComputeLicenseProfileResource IOperationSource<HybridComputeLicenseProfileResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HybridComputeLicenseProfileData.DeserializeHybridComputeLicenseProfileData(document.RootElement);
            return new HybridComputeLicenseProfileResource(_client, data);
        }

        async ValueTask<HybridComputeLicenseProfileResource> IOperationSource<HybridComputeLicenseProfileResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HybridComputeLicenseProfileData.DeserializeHybridComputeLicenseProfileData(document.RootElement);
            return new HybridComputeLicenseProfileResource(_client, data);
        }
    }
}
